/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright (c) 2015 Adobe Systems Incorporated. All rights reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 */

/*jslint vars: true, plusplus: true, devel: true, nomen: true, indent: 4,
maxerr: 50, node: true, regexp: true */
/*global */
(function () {
    
    "use strict";

    var DWFileWatcher      = require('../../DWFileWatch/DWFileWatcher'),
        path               = require('path'),
        DWEvents           = require('../../DWEvents'),
        fs                 = require('fs');


    function getParentDirectory(file) {
        var fileName = path.basename(file),
            parentFullPath,
            extensionName;
        if (fileName === 'package.json' || fileName === 'main.less') {
            // Trigger event to DW which will load the theme extension.
            parentFullPath = path.dirname(file);
            extensionName = path.basename(parentFullPath);
            if (extensionName !== 'user') {
                // We call for loading of extension only if package.json is
                // added to some folder in the user extension path.
                // Added this check so that if user by mistake creates a package.json
                // in user extension path, then there is no need of extension load.
                return parentFullPath;
            }
        }
        return null;
    }

    function fileAdded(file) {
        var parentDirectory = getParentDirectory(file);
        if (parentDirectory) {
            DWEvents.raiseEventOnDW('addCodeTheme', {extensionName: parentDirectory});
        }
    }
    
    
    function fileDeleted(file) {
        var parentDirectory = getParentDirectory(file);
        if (parentDirectory) {
            DWEvents.raiseEventOnDW('deleteCodeTheme', {extensionName: parentDirectory});
        }
    }
    

    function fileChanged(file) {
        var extension = path.extname(file);
        if (extension.toLowerCase() === '.less') {
            // Trigger event to DW whicl will call the refresh theme
            var parentDirectory = path.dirname(file);
            if (parentDirectory) {
                DWEvents.raiseEventOnDW('refreshCodeTheme', {extensionName: parentDirectory});
            }
        }
    }


    function init(DWServiceManager) {
        if (!DWServiceManager.hasService('ThemeCustomizer')) {
            DWServiceManager.registerService('ThemeCustomizer', { major: 1, minor: 0 });
        }
        
        DWEvents.on("userExtensionspath", function (extensionsFolder) {
            var mkdirSync = function (path) {
                try {
                    fs.mkdirSync(path);
                } catch (e) {
                    if (e.code !== 'EEXIST') {
                        throw e;
                    }
                }
            };

            try {
                var dirpath = decodeURI(extensionsFolder.userConfigPath);
                var parts = dirpath.split(path.sep);
                var i;
                // Brackets user congig path contains the following path elements 
                // (<AppData> | <Library>) / 'Brackets' / 'extensions' / 'user' 
                // Directory path till 'Brackets' is always ensured before the following logic is executed
                // Here we ensure 'extensions/user' directory before initializing file watcher for that path
                for (i = parts.length - 1; i <= parts.length; i++) {
                    mkdirSync(path.join.apply(null, parts.slice(0, i)));
                }
                DWFileWatcher.watchFileOrFolder(dirpath, ["less", "json"]);
                DWFileWatcher.on(DWFileWatcher.FILE_CHANGED_EVENT, fileChanged);
                DWFileWatcher.on(DWFileWatcher.FILE_ADDED_EVENT, fileAdded);
                DWFileWatcher.on(DWFileWatcher.FILE_REMOVED_EVENT, fileDeleted);
            } catch (e) {
            }
        });
    }


    exports.init = init;
    
}());